#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

vector<vector<int>> G;
vector<int> used;
vector<int> cycl;
vector<int> foundedCycl;
vector<int> goodCycl;
bool isFounded = false;
int n, m;

void dfs(int v) {
  if (isFounded) 
    return;
  used[v] = 1;
  cycl.push_back(v);
  for (int i = 0; i < G[v].size(); i++) {
    if (used[G[v][i]] == 1) {
      vector<int> saveCycl = cycl;
      while (cycl.back() != G[v][i]) {
        foundedCycl.push_back(cycl.back());
	cycl.pop_back();
      }
      foundedCycl.push_back(cycl.back());
      cycl.pop_back();
      reverse(foundedCycl.begin(), foundedCycl.end());
      
      if (foundedCycl.size() == n) {
        isFounded = true;
	goodCycl = foundedCycl;
	break;
      }
      
      cycl = saveCycl;
      foundedCycl.clear();
    }
  }
  if (!isFounded)
    for (int i = 0; i < G[v].size(); i++)
      if (used[G[v][i]] == 0)
        dfs(G[v][i]);
  cycl.pop_back();
  used[v] = 2;
}

int main() {
  scanf("%d%d", &n, &m);
  G.resize(n);
  int from, to;
  for (int i = 0; i < m; i++) {
    scanf("%d%d", &from, &to);
    G[from - 1].push_back(to - 1);
  }
  for (int vert = 0; vert < std::min(10, n); vert++) {
    cycl.clear();
    foundedCycl.clear();
    used.clear();
    used.resize(n, 0);
    dfs(vert);
    if (goodCycl.size() == n) {
      printf("YES\n");
      for (int i = 0; i < goodCycl.size(); i++)
        printf("%d ", goodCycl[i] + 1);
      printf("%d", goodCycl[0] + 1);
      printf("\n");
      return 0;
    }
  }
  printf("NO\n");
}
